Imports System.Threading
Imports System.Reflection
Imports DotNetAssembly = System.Reflection.Assembly

Module Module1

    Sub Main()
        ' Prparer un nouvel assembly.
        Dim a As New MyAsmBuilder()
        Dim curAppDomain As AppDomain = Thread.GetDomain()
        a.CreateMyAsm(curAppDomain)

        ' Maintenant on l'utilise !
        Dim asm As DotNetAssembly

        Try
            asm = DotNetAssembly.Load("MyAssembly")
        Catch
            Console.WriteLine("Impossible de trouver l'assembly...")
        End Try

        ' Rcuprer le type HelloWorld.
        Dim hello As Type = asm.GetType("MyAssembly.HelloWorld")

        ' Crer un objet HelloWorld.
        Dim obj As Object = Activator.CreateInstance(hello, Nothing)
        Dim fi As FieldInfo = hello.GetField("Msg")
        fi.SetValue(obj, "C'est si gentil...")
        Dim mi As MethodInfo = hello.GetMethod("SayHello")
        mi.Invoke(obj, Nothing)

        mi = hello.GetMethod("GetMsg")
        Console.WriteLine(mi.Invoke(obj, Nothing))
    End Sub

End Module
